﻿<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Lista członków rodziny</TITLE>
		<script runat="server">

	[DefaultWidth(15)]
	public enum FiltrStn {
		Wszyscy, Tak, Nie
	}
	
	[DefaultWidth(15)]
	public enum FiltrStp {
		Wszyscy, Dziecko, PozostaliKrewni
	}
	
    public class PrnParams: ContextBase {
    
        public PrnParams(Context context): base(context) {
        }
    
        FromTo okres = FromTo.All;
        [Caption("Urodzeni w okresie")]
        [Priority(1)]
        public FromTo OkresUrodzenia {
			get { return okres; }
			set {
				okres = value==FromTo.Empty ? FromTo.All : value;
                OnChanged(EventArgs.Empty);
			}
        }
        
        FiltrStp stp = FiltrStp.Dziecko;
        [Caption("Stopień pokrewieństwa")]
        [Priority(2)]
        public FiltrStp Stp {
            get { return stp; }
            set {
                stp = value;
                OnChanged(EventArgs.Empty);
            }
        }        
        
        FiltrStn stn = FiltrStn.Wszyscy;
        [Caption("Niepełnosprawni")]
        [Priority(3)]
        public FiltrStn Stn {
            get { return stn; }
            set {
                stn = value;
                OnChanged(EventArgs.Empty);
            }
        }        
        
        public bool Filter(CzlonekRodziny r) {
			if (okres!=FromTo.All && !okres.Contains(r.Urodzony.Data))
				return false;
			switch (stp) {
				case FiltrStp.Dziecko:
					if (r.StPokrewienstwa!=KodStPokrewienstwa.Dziecko)
						return false;
					break;
				case FiltrStp.PozostaliKrewni:
					if (r.StPokrewienstwa==KodStPokrewienstwa.Dziecko)
						return false;
					break;
			}
			
			switch (stn) {
				case FiltrStn.Tak:
					if (r.StNiepelnosprawnosci==KodStNiepelnosprawnosci.Brak)
						return false;
					break;
				case FiltrStn.Nie:
					if (r.StNiepelnosprawnosci!=KodStNiepelnosprawnosci.Brak)
						return false;
					break;
			}
			
			return true;
        }
    }
    
    PrnParams pars = null;
    [Context]
    public PrnParams Params {
        get { return pars; }
        set { pars = value; }
    }

	int lp = 0;
    void dc_ContextLoad(Object sender, EventArgs args) {		
		if (pars.OkresUrodzenia==FromTo.All)
			ReportHeader["OKR"] = "";
		else
			ReportHeader["OKR"] = "|</strong>Urodzeni w okresie: <strong>" + pars.OkresUrodzenia;
			
		switch (pars.Stp){
			case FiltrStp.Wszyscy:
				ReportHeader["STP"] = "";
				break;
			case FiltrStp.Dziecko:
				ReportHeader["STP"] = "|</strong>St.pokrewieństwa: <strong>" + pars.Stp;
				colStp.Visible = false;
				break;
			case FiltrStp.PozostaliKrewni:
				ReportHeader["STP"] = "|</strong>St.pokrewieństwa: <strong>Pozostali krewni";
				break;
		}

		if (pars.Stn==FiltrStn.Wszyscy)
			ReportHeader["STN"] = "";
		else
			ReportHeader["STN"] = "|</strong>St.niepełnosprawności: <strong>" + pars.Stn;
	}
	
    void Grid_BeforeRow(Object sender, RowEventArgs args) {
		Pracownik idx = (Pracownik)args.Row;
		bool any = false;
		foreach (CzlonekRodziny r in idx.Rodzina)
			if (pars.Filter(r)) {
				any = true;
				colOsoba.AddLine(r);
				colData.AddLine(r.Urodzony.Data==Date.Empty ? "&nbsp;" : r.Urodzony.Data.ToString());
				colStp.AddLine(r.StPokrewienstwa==KodStPokrewienstwa.Brak ? "&nbsp;" : CaptionAttribute.EnumToString(r.StPokrewienstwa));
				colStn.AddLine(r.StNiepelnosprawnosci==KodStNiepelnosprawnosci.Brak ? "&nbsp;" : CaptionAttribute.EnumToString(r.StNiepelnosprawnosci));
			}

		if (any)
			colLp.EditValue = ++lp;
		else
			args.VisibleRow = false;
    }
    
    static void Msg(object value) {
    }

		</script>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" oncontextload="dc_ContextLoad" runat="server"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" title="Lista członków rodziny%OKR%%STP%%STN%"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" OnBeforeRow="Grid_BeforeRow" RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" Caption="LP." ID="colLp"></ea:GridColumn>
					<ea:GridColumn Align="Left" DataMember="Pracownik" Caption="Pracownik" VAlign="Top"></ea:GridColumn>
					<ea:GridColumn Caption="Członkowie rodziny~Nazwisko i imię" ID="colOsoba"></ea:GridColumn>
					<ea:GridColumn Width="10" Caption="Członkowie rodziny~Data urodzenia" ID="colData"></ea:GridColumn>
					<ea:GridColumn Width="20" Caption="Członkowie rodziny~St.pokrewieństwa" ID="colStp" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn Width="20" Caption="Członkowie rodziny~St.niepełnosprawności" ID="colStn" NoWrap="True"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

